package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.model.Tarea;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0490s00Service generated by UDA, 06-Feb-2017 12:46:17.
 * 
 * @author UDA
 */

public interface TareaService {

	/**
	 * Inserts a single row in the Ab0490s00 table.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *  Ab0490s00
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @return the tarea
	 */
	Tarea add(Tarea ab0490s00);

	/**
	 * Updates a single row in the Ab0490s00 table.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *  Ab0490s00
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @return the tarea
	 */
	Tarea update(Tarea ab0490s00);

	/**
	 * Finds a single row in the Ab0490s00 table.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *  Ab0490s00
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @return the tarea
	 */
	Tarea find(Tarea ab0490s00);

	/**
	 * Finds a single row in the Ab0490s00 table.
	 * 
	 *  taskId
	 *            String
	 *  procedureId
	 *            String
	 *  Ab0490s00
	 *
	 * @param taskId the task id
	 * @param procedureId the procedure id
	 * @return the tarea
	 */
	public Tarea findByTaskIdProcedureId(String taskId, String procedureId);

	/**
	 * Deletes a single row in the Ab0490s00 table.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 */
	void remove(Tarea ab0490s00);

	/**
	 * Finds a list of rows in the Ab0490s00 table.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0490s00>
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<Tarea> findAll(Tarea ab0490s00, JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0490s00 table using like.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0490s00>
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<Tarea> findAllLike(Tarea ab0490s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0490s00 table.
	 * 
	 *  filterAb0490s00
	 *            Ab0490s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0490s00>
	 *
	 * @param filterAb0490s00 the filter ab 0490 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<Tarea> filter(Tarea filterAb0490s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0490s00 table.
	 * 
	 *  filterAb0490s00
	 *            Ab0490s00
	 *  searchAb0490s00
	 *            Ab0490s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0490s00>>
	 *
	 * @param filterAb0490s00 the filter ab 0490 s 00
	 * @param searchAb0490s00 the search ab 0490 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<Tarea>> search(Tarea filterAb0490s00,
			Tarea searchAb0490s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0490s00 table.
	 * 
	 *  filterAb0490s00
	 *            Ab0490s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0490s00 the filter ab 0490 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(Tarea filterAb0490s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

}
